editAreaLoader.load_syntax["lasso"] = {
	'COMMENT_SINGLE': {1: '//'},
	'COMMENT_MULTI': {'/*': '*/'},
	'QUOTEMARKS' : ['"', "'"],
	'KEYWORD_CASE_SENSITIVE': false,
	'KEYWORDS': {'primitives': [
		'true', 'false', 'null', 'string', 'date', 'integer', 'decimal', 'date', 'xml', 'boolean', 'bytes'
	]},
	'OPERATORS':[
		'+', '-', '/', '*', '=', '<', '>', '%', '!', '&&', '&', '||', '\\', '@', 
		'>>', '->', '?', ':', '=>', '::', '^', '(', ')', '{', '}', '|'
	],
	'DELIMITERS':['[', ']', '<?lassoscript', '?>', '<?lasso'],
	'REGEXPS': {
		'variables': {
			'search': '()(\\$\\w+)()',
			'class': 'variables',
			'modifiers': 'g',
			'execute': 'before'
		},
		'locals': {
			'search': '()(#\\w+)()',
			'class': 'locals',
			'modifiers': 'g',
			'execute': 'before'
		},
		'members': {
			'search': '((?:\\->)|&)(\\w+)()',
			'class': 'members',
			'modifiers': 'g',
			'execute': 'before'
		},
		'params': {		
			'search': '()(\\-\\w+)()',
			'class': 'params',
			'modifiers': 'g',
			'execute': 'before'
		},
		'numbers': {
			'search': '()([0-9\\.]+)()',
			'class': 'numbers',
			'modifiers': 'g',
			'execute': 'before'
		},
		'tags': {
			'search': '()(/?[a-zA-Z0-9_]+)([:;,\(\)]|(?:\\->))',
			'class': 'tags',
			'modifiers': 'g',
			'execute': 'before'
		}
	},
	'STYLES': {
		'COMMENTS': 'color: #ccc;',
		'QUOTESMARKS': 'color: #900;',
		'KEYWORDS': {
			'primitives': 'color: #f30;'
		},
		'OPERATORS': 'color: #333;',
		'DELIMITERS': 'color: #666;',
		'REGEXPS': {
			'variables': 'color: #360;',
			'locals': 'color: #0c3;',
			'tags': 'color: #00c;',
			'members': 'color: #06f;',
			'params': 'color: #09c;',
			'numbers': 'color: #90c;'
		}		
	}
};
